<?php
/**
 * Product Archive Template
 *
 * This template displays product archive pages including shop page, product categories,
 * and product tags. It shows a list of products with WooCommerce functionality.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

# if there is an archive template, then we need to output it instead of the default archive

$has_wvc_archive_template = false;
$archive_content          = "";

// Get current post type for archive (should be "product" for product archives)
$current_post_type = "product";

// For taxonomy archives, get the post type from the queried object
if (is_tax()) {
    $queried_object = get_queried_object();
    if ($queried_object && isset($queried_object->taxonomy)) {
        $taxonomy = get_taxonomy($queried_object->taxonomy);
        if ($taxonomy && !empty($taxonomy->object_type)) {
            $current_post_type = $taxonomy->object_type[0];
        }
    }
}

// For post type archives, get_post_type() should work
if (is_post_type_archive()) {
    $current_post_type = get_query_var("post_type");
    if (empty($current_post_type)) {
        $current_post_type = "product";
    }
}

// Try to get CPT-specific template using the new function
$archive_template = \WVC\Includes\Theme\Theme_Core::is_there_a_vibecode_template("archive", $current_post_type);

// Fallback to generic "archive" template for "post" type if CPT-specific not found
if (!$archive_template && $current_post_type !== "post") {
    $archive_template = \WVC\Includes\Theme\Theme_Core::is_there_a_vibecode_template("archive", "post");
}

if ($archive_template) {
    $has_wvc_archive_template = true;
    $archive_content          = $archive_template->post_content;
}

if ($has_wvc_archive_template):
    // Pass variables to the template using get_template_part with args
    get_template_part("wvc-archive", null, array(
        "archive_content"          => $archive_content,
        "has_wvc_archive_template" => $has_wvc_archive_template,
        "post_type"                => $current_post_type
    ));

    return;
endif;

get_header();
?>

<main class="site-main bg-white min-h-screen">
    <div class="container mx-auto px-4 py-8">
        <div class="max-w-7xl mx-auto">
            <?php
            /**
             * Hook: woocommerce_before_main_content.
             *
             * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
             * @hooked woocommerce_breadcrumb - 20
             */
            do_action("woocommerce_before_main_content");
            ?>

            <?php
            /**
             * Hook: woocommerce_shop_loop_header.
             *
             * @hooked woocommerce_product_taxonomy_archive_header - 10
             */
            do_action("woocommerce_shop_loop_header");
            ?>

            <?php if (woocommerce_product_loop()) : ?>
                <?php
                /**
                 * Hook: woocommerce_before_shop_loop.
                 *
                 * @hooked woocommerce_output_all_notices - 10
                 * @hooked woocommerce_result_count - 20
                 * @hooked woocommerce_catalog_ordering - 30
                 */
                do_action("woocommerce_before_shop_loop");
                ?>

                <?php woocommerce_product_loop_start(); ?>

                <?php
                if (wc_get_loop_prop("total")) {
                    while (have_posts()) {
                        the_post();

                        /**
                         * Hook: woocommerce_shop_loop.
                         */
                        do_action("woocommerce_shop_loop");

                        wc_get_template_part("content", "product");
                    }
                }
                ?>

                <?php woocommerce_product_loop_end(); ?>

                <?php
                /**
                 * Hook: woocommerce_after_shop_loop.
                 *
                 * @hooked woocommerce_pagination - 10
                 */
                do_action("woocommerce_after_shop_loop");
                ?>
            <?php else : ?>
                <?php
                /**
                 * Hook: woocommerce_no_products_found.
                 *
                 * @hooked wc_no_products_found - 10
                 */
                do_action("woocommerce_no_products_found");
                ?>
            <?php endif; ?>

            <?php
            /**
             * Hook: woocommerce_after_main_content.
             *
             * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
             */
            do_action("woocommerce_after_main_content");
            ?>
        </div>
    </div>
</main>

<?php
/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
do_action("woocommerce_sidebar");
?>

<?php get_footer(); ?>