<?php
/**
 * Archive Template
 *
 * This template displays archive pages including category, tag, author,
 * and date archives. It shows a list of posts with pagination and
 * appropriate archive headers.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

# if there is an archive template, then we need to output it instead of the default archive

$has_wvc_archive_template = false;
$archive_content          = "";

// Get current post type for archive
$current_post_type = get_post_type();

// For taxonomy archives, get the post type from the queried object
if (is_tax() || is_category() || is_tag()) {
    $queried_object = get_queried_object();
    if ($queried_object && isset($queried_object->taxonomy)) {
        $taxonomy = get_taxonomy($queried_object->taxonomy);
        if ($taxonomy && !empty($taxonomy->object_type)) {
            $current_post_type = $taxonomy->object_type[0];
        }
    }
}

// For post type archives, get_post_type() should work
if (is_post_type_archive()) {
    $current_post_type = get_query_var("post_type");
    if (empty($current_post_type)) {
        $current_post_type = "post";
    }
}

// Try to get CPT-specific template using the new function
$archive_template = \WVC\Includes\Theme\Theme_Core::is_there_a_vibecode_template("archive", $current_post_type);

// Fallback to generic "archive" template for "post" type if CPT-specific not found
if (!$archive_template && $current_post_type !== "post") {
    $archive_template = \WVC\Includes\Theme\Theme_Core::is_there_a_vibecode_template("archive", "post");
}

if ($archive_template) {
    $has_wvc_archive_template = true;
    $archive_content          = $archive_template->post_content;
}

if ($has_wvc_archive_template):
    // Pass variables to the template using get_template_part with args
    get_template_part("wvc-archive", null, array(
        "archive_content"          => $archive_content,
        "has_wvc_archive_template" => $has_wvc_archive_template,
        "post_type"                => $current_post_type
    ));

    return;
endif;

get_header();

?>

<main class="site-main bg-white min-h-screen">
	<div class="container mx-auto px-4 py-8">
		<div class="max-w-7xl mx-auto">
			<?php if ( have_posts() ) : ?>
				<header class="page-header mb-12 text-center">
					<?php the_archive_title( '<h1 class="page-title text-4xl font-bold text-black mb-4">', '</h1>' ); ?>
					<?php the_archive_description( '<div class="archive-description text-lg text-gray-600 max-w-3xl mx-auto">', '</div>' ); ?>
				</header>

				<div class="posts-container">
					<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
						<?php
						while ( have_posts() ) :
							the_post();
							?>
							<article id="post-<?php the_ID(); ?>" <?php post_class( 'post bg-white border border-gray-500 rounded-lg overflow-hidden hover:border-primary-500 transition-colors duration-300' ); ?>>
								<?php if ( has_post_thumbnail() ) : ?>
									<div class="post-thumbnail">
										<a href="<?php the_permalink(); ?>" class="block">
											<?php the_post_thumbnail( 'wvc-featured', array( 'class' => 'w-full h-48 object-cover' ) ); ?>
										</a>
									</div>
								<?php endif; ?>
								
								<div class="p-6">
									<header class="post-header mb-4">
										<h2 class="post-title text-xl font-semibold text-black mb-3">
											<a href="<?php the_permalink(); ?>" class="hover:text-primary-500 transition-colors duration-300"><?php the_title(); ?></a>
										</h2>
										
										<div class="post-meta text-sm text-gray-600 space-x-4">
											<span class="post-date">
												<time datetime="<?php echo get_the_date( 'c' ); ?>">
													<?php echo get_the_date(); ?>
												</time>
											</span>
											<span class="post-author">
												<?php _e( 'by', 'wvc-theme' ); ?> <?php the_author(); ?>
											</span>
										</div>
									</header>

									<div class="post-content">
										<div class="text-gray-700 mb-4 line-clamp-3">
											<?php the_excerpt(); ?>
										</div>
										<a href="<?php the_permalink(); ?>" class="inline-block bg-primary-500 text-white px-6 py-2 rounded-md hover:bg-primary-600 transition-colors duration-300">
											<?php _e( 'Read More', 'wvc-theme' ); ?>
										</a>
									</div>
								</div>
							</article>
						<?php endwhile; ?>
					</div>
				</div>

				<?php
				// Pagination with Tailwind styles
				$pagination = get_the_posts_pagination(
					array(
						'mid_size'  => 2,
						'prev_text' => __( 'Previous', 'wvc-theme' ),
						'next_text' => __( 'Next', 'wvc-theme' ),
					)
				);
				
				// Apply Tailwind classes to pagination
				$pagination = str_replace(
					array(
						'<nav class="navigation pagination"',
						'<div class="nav-links"',
						'<span aria-current="page" class="page-numbers current"',
						'<a class="page-numbers"',
						'<a class="prev page-numbers"',
						'<a class="next page-numbers"',
					),
					array(
						'<nav class="navigation pagination mt-12"',
						'<div class="nav-links flex justify-center items-center space-x-2"',
						'<span aria-current="page" class="page-numbers current bg-primary-500 text-white px-4 py-2 rounded-md"',
						'<a class="page-numbers bg-white border border-gray-500 text-black px-4 py-2 rounded-md hover:bg-primary-500 hover:text-white transition-colors duration-300"',
						'<a class="prev page-numbers bg-white border border-gray-500 text-black px-4 py-2 rounded-md hover:bg-primary-500 hover:text-white transition-colors duration-300"',
						'<a class="next page-numbers bg-white border border-gray-500 text-black px-4 py-2 rounded-md hover:bg-primary-500 hover:text-white transition-colors duration-300"',
					),
					$pagination
				);
				
				echo $pagination;
				?>

			<?php else : ?>
				<section class="no-results bg-gray-100 rounded-lg p-8 text-center">
					<header class="page-header mb-6">
						<h1 class="page-title text-3xl font-bold text-black mb-4"><?php _e( 'Nothing here', 'wvc-theme' ); ?></h1>
					</header>

					<div class="page-content">
						<p class="text-gray-700 mb-6"><?php _e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'wvc-theme' ); ?></p>
						<div class="max-w-md mx-auto">
							<?php get_search_form(); ?>
						</div>
					</div>
				</section>
			<?php endif; ?>
		</div>
	</div>
</main>

<?php get_footer(); ?>