<?php
/**
 * Comments Template
 *
 * This template displays the comments section including the comment list,
 * comment form, and comment navigation. It handles password-protected posts
 * and various comment states.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

if (post_password_required()) {
    return;
}

// Get commenter information for the form
$commenter = wp_get_current_commenter();
?>

<div id="comments" class="comments-area bg-white rounded-lg border border-gray-500 p-6 mt-8">

    <?php if (have_comments()) : ?>
        <h2 class="comments-title text-xl lg:text-2xl font-bold text-black mb-6 pb-4 border-b border-gray-200">
            <?php
            $comment_count = get_comments_number();
            if ("1" === $comment_count) {
                printf(
                    esc_html_x("One thought on &ldquo;%1\$s&rdquo;", "comments title", "wvc-theme"),
                    "<span class=\"text-primary-600\">" . get_the_title() . "</span>"
                );
            } else {
                printf(
                    esc_html(
                        _nx(
                            "%1\$s thought on &ldquo;%2\$s&rdquo;",
                            "%1\$s thoughts on &ldquo;%2\$s&rdquo;",
                            $comment_count,
                            "comments title",
                            "wvc-theme"
                        )
                    ),
                    number_format_i18n($comment_count),
                    "<span class=\"text-primary-600\">" . get_the_title() . "</span>"
                );
            }
            ?>
        </h2>

        <ol class="comment-list space-y-6">
            <?php
            // Debug: Check if function exists
            if (!function_exists("wvc_comment_callback")) {
                echo "<!-- DEBUG: wvc_comment_callback function not found -->";
            } else {
                echo "<!-- DEBUG: wvc_comment_callback function found -->";
            }
            
            wp_list_comments(
                array(
                "style"      => "ol",
                "short_ping" => true,
                "callback"   => "WVC\Includes\Theme\comment_callback",
                )
            );
            ?>
        </ol>

        <div class="comments-navigation mt-8 pt-6 border-t border-gray-200">
            <?php the_comments_navigation(); ?>
        </div>

    <?php endif; ?>

    <?php if (!comments_open() && get_comments_number() && post_type_supports(get_post_type(), "comments")) : ?>
        <div class="no-comments bg-gray-100 p-4 rounded-lg border-l-4 border-gray-400">
            <p class="text-black font-medium"><?php esc_html_e("Comments are closed.", "wvc-theme"); ?></p>
        </div>
    <?php endif; ?>

    <div class="comment-form-section mt-8 pt-6 border-t border-gray-200">
        <?php
        comment_form(
            array(
            "title_reply_before" => "<h2 id=\"reply-title\" class=\"comment-reply-title text-lg font-bold text-black mb-6\">",
            "title_reply_after"  => "</h2>",
            "class_submit"       => "btn bg-primary-500 hover:bg-primary-600 text-white font-medium py-2 px-6 rounded-lg transition-colors duration-200",
            "class_form"         => "comment-form space-y-4",
            "submit_button"      => '<input name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s" />',
            "submit_field"       => '<div class="comment-form-submit mb-4"><p class="form-submit">%1$s %2$s</p></div>',
            "comment_field"      => '<div class="comment-form-comment mb-4"><label for="comment" class="block text-sm font-medium text-black mb-2">' . _x("Comment", "noun", "wvc-theme") . '</label><textarea id="comment" name="comment" cols="45" rows="8" aria-required="true" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 text-black" placeholder="' . esc_attr__("Write your comment here...", "wvc-theme") . '"></textarea></div>',
            "fields"             => array(
                "author" => '<div class="comment-form-author mb-4"><label for="author" class="block text-sm font-medium text-black mb-2">' . _x("Name", "noun", "wvc-theme") . ' <span class="required text-red-500">*</span></label><input id="author" name="author" type="text" value="' . esc_attr($commenter["comment_author"]) . '" size="30" maxlength="245" aria-required="true" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 text-black" /></div>',
                "email"  => '<div class="comment-form-email mb-4"><label for="email" class="block text-sm font-medium text-black mb-2">' . _x("Email", "noun", "wvc-theme") . ' <span class="required text-red-500">*</span></label><input id="email" name="email" type="email" value="' . esc_attr($commenter["comment_author_email"]) . '" size="30" maxlength="100" aria-describedby="email-notes" aria-required="true" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 text-black" /></div>',
                "url"    => '<div class="comment-form-url mb-4"><label for="url" class="block text-sm font-medium text-black mb-2">' . _x("Website", "noun", "wvc-theme") . '</label><input id="url" name="url" type="url" value="' . esc_attr($commenter["comment_author_url"]) . '" size="30" maxlength="200" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-primary-500 text-black" /></div>',
            ),
            )
        );
        ?>
    </div>

</div> 