<?php
/**
 * Bulk Operations Loader
 *
 * This file bootstraps and initializes all bulk operations functionality.
 * It loads required classes, registers hooks, and sets up the complete
 * bulk operations system for template management in the WVC theme.
 *
 * @package    WVC_Theme
 * @subpackage Bulk_Operations
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

if (!defined("ABSPATH")) {
    exit;
}

/**
 * WVC Bulk Operations Module
 */
class WVC_Bulk_Operations_Module
{
    
    private static $instance = null;
    
    public static function get_instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct()
    {
        $this->load_dependencies();
        $this->init_components();
    }
    
    /**
     * Load required files
     */
    private function load_dependencies()
    {
        $includes_path = get_template_directory() . "/includes/bulk-operations/";
        
        // Load core classes
        include_once $includes_path . "class-template-post-type.php";
        include_once $includes_path . "class-bulk-operations-rest-api.php";
        include_once $includes_path . "class-structure-validator.php";
    }
    
    /**
     * Initialize components
     */
    private function init_components()
    {
        // Initialize post type
        new WVC_Template_Post_Type();
        
        // Initialize REST API
        new WVC_Bulk_Operations_REST_API();
    }
}

// Initialize the module
function wvc_init_bulk_operations_module()
{
    return WVC_Bulk_Operations_Module::get_instance();
}

// Hook into WordPress initialization
add_action("init", "wvc_init_bulk_operations_module", 5); 