<?php

namespace WVC\FormSubmissions;

/**
 * Admin Assets - CSS and JavaScript
 *
 * All CSS and JavaScript for admin pages
 *
 * @package    WVC_Theme
 * @subpackage FormSubmissions
 */

// Prevent direct access
if (!defined("ABSPATH")) {
    exit;
}

/**
 * Add enhanced admin styles and JavaScript for form submissions
 */
function wvc_admin_enhanced_styles_scripts() {
    $screen = get_current_screen();
    if ($screen->post_type !== 'wvc_form_data' &&
        $screen->id !== 'wvc_form_data_page_wvc_form_overview' &&
        $screen->id !== 'admin_page_wvc_form_submissions') {
        return;
    }

    ?>
    <style>
        /* Form overview page styles */
        .wvc-forms-table .button {
            margin-right: 5px;
        }
        .wvc-stats-summary {
            border-left: 4px solid #0073aa;
            background: linear-gradient(135deg, #f1f1f1 0%, #e8e8e8 100%);
        }
        .wvc-forms-table table th,
        .wvc-forms-table table td {
            padding: 12px;
            vertical-align: middle;
        }
        .wvc-forms-table tbody tr {
            transition: all 0.2s ease;
        }
        .wvc-forms-table tbody tr:hover {
            background-color: #f8f9fa;
            transform: translateX(3px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        .wvc-forms-table .button-primary {
            background: #0073aa;
            border-color: #005177;
            transition: all 0.2s ease;
        }
        .wvc-forms-table .button-primary:hover {
            background: #005177;
            border-color: #003d5c;
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }

        /* Form-specific submissions page styles */
        .wvc-form-info {
            margin: 20px 0;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 5px;
            border-left: 4px solid #0073aa;
        }

        .wvc-breadcrumb {
            margin: 15px 0;
            font-size: 14px;
        }

        .wvc-breadcrumb a {
            text-decoration: none;
            color: #0073aa;
        }

        .wvc-breadcrumb a:hover {
            text-decoration: underline;
        }

        .wvc-dynamic-table {
            margin-top: 20px;
        }

        .wvc-submissions-table {
            border: 1px solid #e1e1e1;
        }

        .wvc-submissions-table th {
            background: #f8f9fa;
            font-weight: 600;
            border-bottom: 2px solid #dee2e6;
        }

        .wvc-submissions-table td {
            border-bottom: 1px solid #dee2e6;
            vertical-align: middle;
        }

        .wvc-submissions-table tbody tr:hover {
            background-color: #f8f9fa;
        }

        .wvc-submissions-table .button-small {
            font-size: 11px;
            padding: 2px 8px;
            height: auto;
            line-height: 1.4;
        }

        .wvc-table-actions {
            margin-top: 20px;
            text-align: right;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 3px;
        }

        /* Filter dropdown styles */
        #form_id_filter {
            min-width: 200px;
            margin-left: 10px;
        }

        /* Enhanced notice styles */
        .notice.notice-info p {
            font-size: 14px;
        }
        .notice.notice-info a {
            text-decoration: none;
            font-weight: 500;
        }
        .notice.notice-info a:hover {
            text-decoration: underline;
        }

        /* Form overview cards */
        .wvc-form-card {
            background: #fff;
            border: 1px solid #e1e1e1;
            border-radius: 8px;
            padding: 20px;
            margin: 10px 0;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }
        .wvc-form-card:hover {
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
            transform: translateY(-2px);
        }
        .wvc-form-card h3 {
            margin-top: 0;
            color: #0073aa;
        }
        .wvc-form-card .stats {
            display: flex;
            justify-content: space-between;
            margin: 15px 0;
        }
        .wvc-form-card .stat-item {
            text-align: center;
        }
        .wvc-form-card .stat-number {
            font-size: 24px;
            font-weight: bold;
            color: #0073aa;
        }
        .wvc-form-card .stat-label {
            font-size: 12px;
            color: #666;
            text-transform: uppercase;
        }

        /* Loading states */
        .wvc-loading {
            opacity: 0.6;
            pointer-events: none;
        }

        /* Mobile responsive */
        @media (max-width: 768px) {
            .wvc-forms-table table {
                font-size: 12px;
            }
            .wvc-forms-table table th,
            .wvc-forms-table table td {
                padding: 8px;
            }
            .wvc-form-card .stats {
                flex-direction: column;
            }
            .wvc-form-card .stat-item {
                margin: 5px 0;
            }
        }

        /* Edit form submission page styles */
        .wvc-edit-submission-form .form-table th {
            width: 200px;
            padding: 15px 10px 15px 0;
        }

        .wvc-edit-submission-form .form-table td {
            padding: 15px 10px;
        }

        .wvc-edit-submission-form input[type="text"],
        .wvc-edit-submission-form input[type="email"],
        .wvc-edit-submission-form input[type="tel"],
        .wvc-edit-submission-form input[type="url"],
        .wvc-edit-submission-form input[type="number"],
        .wvc-edit-submission-form textarea {
            width: 100%;
            max-width: 600px;
        }

        .wvc-edit-submission-form textarea {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
            font-size: 14px;
        }

        .wvc-edit-submission-form .submit {
            padding: 20px 0;
            border-top: 1px solid #ddd;
            margin-top: 20px;
        }

        /* Delete button hover state */
        .button-link-delete:hover {
            color: #a00 !important;
        }

        /* Success notices */
        .notice.is-dismissible {
            position: relative;
            padding-right: 38px;
        }

        /* Email notification settings panel */
        .wvc-form-settings {
            margin: 20px 0;
            background: #fff;
            border: 1px solid #e1e1e1;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .wvc-form-settings:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.12);
        }

        .wvc-settings-header {
            background: linear-gradient(135deg, #0073aa 0%, #005177 100%);
            color: #fff;
            padding: 15px 20px;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            user-select: none;
            transition: background 0.3s ease;
        }

        .wvc-settings-header:hover {
            background: linear-gradient(135deg, #005177 0%, #003d5c 100%);
        }

        .wvc-settings-header h3 {
            margin: 0;
            font-size: 16px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .wvc-settings-header h3:before {
            /* content: "⚙️"; */
            font-size: 18px;
        }

        .wvc-settings-toggle {
            font-size: 20px;
            transition: transform 0.3s ease;
            color: #fff;
        }

        .wvc-settings-toggle.collapsed {
            transform: rotate(-90deg);
        }

        .wvc-settings-body {
            padding: 20px;
            display: none;
        }

        .wvc-settings-body.expanded {
            display: block;
            animation: slideDown 0.3s ease;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .wvc-form-settings .form-table {
            margin-top: 0;
        }

        .wvc-form-settings .submit {
            margin: 0;
            padding-top: 15px;
            border-top: 1px solid #e1e1e1;
        }

        /* Email list styling */
        .wvc-email-list-container {
            margin-top: 10px;
        }

        .wvc-email-input-group {
            display: flex;
            gap: 10px;
            margin-bottom: 15px;
        }

        .wvc-email-input-group input[type="email"] {
            flex: 1;
            min-width: 0;
        }

        .wvc-email-input-group .button {
            flex-shrink: 0;
        }

        .wvc-email-list {
            list-style: none;
            margin: 15px 0 0 0;
            padding: 0;
            max-height: 300px;
            overflow-y: auto;
        }

        .wvc-email-list:empty {
            display: none;
        }

        .wvc-email-list-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 10px 15px;
            margin-bottom: 8px;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border: 1px solid #dee2e6;
            border-radius: 6px;
            transition: all 0.2s ease;
        }

        .wvc-email-list-item:hover {
            background: linear-gradient(135deg, #e9ecef 0%, #dee2e6 100%);
            transform: translateX(5px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .wvc-email-list-item-text {
            display: flex;
            align-items: center;
            gap: 10px;
            font-weight: 500;
            color: #333;
        }

        .wvc-email-list-item-text:before {
            content: "✉️";
            font-size: 16px;
        }

        .wvc-email-list-item .button-link-delete {
            color: #dc3545;
            text-decoration: none;
            font-size: 14px;
            padding: 5px 10px;
            transition: all 0.2s ease;
        }

        .wvc-email-list-item .button-link-delete:hover {
            color: #fff;
            background: #dc3545;
            border-radius: 4px;
        }

        .wvc-email-count {
            display: inline-block;
            background: #28a745;
            color: #fff;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
            margin-left: 10px;
        }

        .wvc-settings-status {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px 15px;
            background: #f8f9fa;
            border-left: 4px solid #0073aa;
            border-radius: 4px;
            margin-bottom: 20px;
        }

        .wvc-settings-status.enabled {
            background: #d4edda;
            border-left-color: #28a745;
        }

        .wvc-settings-status.disabled {
            background: #fff3cd;
            border-left-color: #ffc107;
        }

        .wvc-settings-status-icon {
            font-size: 20px;
        }

        /* Export panel styles */
        .wvc-export-panel {
            margin: 20px 0;
        }

        .wvc-export-panel .wvc-settings-header {
            background: linear-gradient(135deg, #2271b1 0%, #135e96 100%);
        }

        .wvc-export-panel .wvc-settings-header:hover {
            background: linear-gradient(135deg, #135e96 0%, #0a4b78 100%);
        }

        /* .wvc-export-panel .wvc-settings-header h3:before {
            content: "📊";
        } */

        #wvc_custom_date_row input[type="date"] {
            margin: 0 5px;
        }

        /* Hooks panel styles */
        .wvc-hooks-panel {
            margin: 20px 0;
        }

        .wvc-hooks-panel .wvc-settings-header {
            background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%);
        }

        .wvc-hooks-panel .wvc-settings-header:hover {
            background: linear-gradient(135deg, #1e7e34 0%, #155724 100%);
        }

        .wvc-hook-item {
            border: 1px solid #dee2e6;
            padding: 15px;
            margin-bottom: 15px;
            border-radius: 6px;
            background: #f8f9fa;
            position: relative;
        }

        .wvc-hook-item-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .wvc-hook-item-left {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .wvc-hook-type-badge {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            padding: 4px 10px;
            background: #4a154b;
            color: white;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 600;
        }

        .wvc-hook-type-badge:before {
            content: "⚡";
            font-size: 14px;
        }

        .wvc-hook-item-right {
            display: flex;
            gap: 8px;
            align-items: center;
        }

        .wvc-hook-field {
            margin-bottom: 12px;
        }

        .wvc-hook-field label {
            display: block;
            margin-bottom: 5px;
            font-weight: 600;
            font-size: 13px;
        }

        .wvc-hook-field input[type="text"],
        .wvc-hook-field input[type="url"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }

        .wvc-hook-field input[type="text"]:focus,
        .wvc-hook-field input[type="url"]:focus {
            border-color: #28a745;
            outline: none;
            box-shadow: 0 0 0 1px #28a745;
        }

        .wvc-hook-field small {
            display: block;
            margin-top: 4px;
            color: #666;
            font-size: 12px;
        }

        .wvc-hook-remove-btn {
            background: #dc3545;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            transition: background 0.2s;
        }

        .wvc-hook-remove-btn:hover {
            background: #c82333;
        }

        .wvc-hook-test-btn {
            background: #17a2b8;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            transition: background 0.2s;
        }

        .wvc-hook-test-btn:hover {
            background: #138496;
        }

        .wvc-hook-test-btn:disabled,
        .wvc-hook-remove-btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }

        .wvc-add-hook-btn {
            background: #28a745;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.2s;
            margin-bottom: 15px;
        }

        .wvc-add-hook-btn:hover {
            background: #1e7e34;
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }

        .wvc-add-hook-btn:before {
            content: "+ ";
            font-size: 16px;
        }

        .wvc-hook-status-message {
            padding: 8px 12px;
            border-radius: 4px;
            margin-top: 10px;
            font-size: 13px;
        }

        .wvc-hook-status-message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .wvc-hook-status-message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .wvc-hooks-global-toggle {
            margin-bottom: 15px;
            padding: 12px;
            background: #fff;
            border: 1px solid #dee2e6;
            border-radius: 4px;
        }

        .wvc-hooks-global-toggle label {
            display: flex;
            align-items: center;
            gap: 8px;
            font-weight: 600;
            cursor: pointer;
        }

        .wvc-hooks-global-toggle input[type="checkbox"] {
            width: 20px;
            height: 20px;
            cursor: pointer;
        }
    </style>

    <script>
        jQuery(document).ready(function($) {
            // Auto-submit form filter when changed
            $('#form_id_filter').on('change', function() {
                var formId = $(this).val();
                var currentUrl = window.location.href.split('?')[0];
                var newUrl = currentUrl + '?post_type=wvc_form_data';

                if (formId) {
                    newUrl += '&form_id=' + encodeURIComponent(formId);
                }

                window.location.href = newUrl;
            });

            // Add loading state to buttons
            $('.wvc-forms-table .button').on('click', function() {
                $(this).addClass('wvc-loading').text('Loading...');
            });

            // Enhance form cards with click-to-view functionality
            $('.wvc-form-card').on('click', function(e) {
                if (!$(e.target).is('a, button')) {
                    var viewUrl = $(this).find('.button-primary').attr('href');
                    if (viewUrl) {
                        window.location.href = viewUrl;
                    }
                }
            });

            // Add tooltips to statistics
            $('.stat-item').each(function() {
                var $this = $(this);
                var label = $this.find('.stat-label').text();
                var number = $this.find('.stat-number').text();
                $this.attr('title', label + ': ' + number);
            });

            // Highlight current filter in dropdown
            var urlParams = new URLSearchParams(window.location.search);
            var currentFormId = urlParams.get('form_id');
            if (currentFormId) {
                $('#form_id_filter').val(currentFormId);
                $('#form_id_filter').css('background-color', '#fff3cd');
            }

            // Collapsible settings panel
            $('.wvc-settings-header').on('click', function() {
                var $body = $(this).siblings('.wvc-settings-body');
                var $toggle = $(this).find('.wvc-settings-toggle');

                if ($body.hasClass('expanded')) {
                    $body.removeClass('expanded').slideUp(300);
                    $toggle.addClass('collapsed');
                } else {
                    $body.addClass('expanded').slideDown(300);
                    $toggle.removeClass('collapsed');
                }
            });

            // Show/hide custom date inputs based on date range selection
            $('#wvc_export_date_range').on('change', function() {
                if ($(this).val() === 'custom') {
                    $('#wvc_custom_date_row').slideDown(200);
                } else {
                    $('#wvc_custom_date_row').slideUp(200);
                }
            });

            // Dynamic email list management
            $('#wvc_add_email_btn').on('click', function(e) {
                e.preventDefault();

                var emailInput = $('#wvc_new_email');
                var email = emailInput.val().trim();

                // Validate email
                if (!email) {
                    alert('Please enter an email address');
                    return;
                }

                var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(email)) {
                    alert('Please enter a valid email address');
                    return;
                }

                // Check for duplicates
                var exists = false;
                $('.wvc-email-list-item').each(function() {
                    if ($(this).data('email') === email) {
                        exists = true;
                        return false;
                    }
                });

                if (exists) {
                    alert('This email address is already in the list');
                    return;
                }

                // Add to list
                wvcAddEmailToList(email);

                // Clear input
                emailInput.val('');
                emailInput.focus();

                // Update count
                wvcUpdateEmailCount();
            });

            // Allow Enter key to add email
            $('#wvc_new_email').on('keypress', function(e) {
                if (e.which === 13) {
                    e.preventDefault();
                    $('#wvc_add_email_btn').click();
                }
            });

            // Remove email from list
            $(document).on('click', '.wvc-remove-email', function(e) {
                e.preventDefault();

                if (confirm('Remove this email address from the list?')) {
                    $(this).closest('.wvc-email-list-item').fadeOut(300, function() {
                        $(this).remove();
                        wvcUpdateEmailCount();
                    });
                }
            });

            // Helper function to add email to list
            function wvcAddEmailToList(email) {
                var $list = $('#wvc_email_list');
                var $item = $('<li>', {
                    'class': 'wvc-email-list-item',
                    'data-email': email,
                    'style': 'display: none;'
                });

                var $text = $('<span>', {
                    'class': 'wvc-email-list-item-text',
                    'text': email
                });

                var $input = $('<input>', {
                    'type': 'hidden',
                    'name': 'email_addresses[]',
                    'value': email
                });

                var $removeBtn = $('<a>', {
                    'href': '#',
                    'class': 'button-link-delete wvc-remove-email',
                    'text': 'Remove'
                });

                $item.append($text).append($input).append($removeBtn);
                $list.append($item);
                $item.fadeIn(300);
            }

            // Helper function to update email count
            function wvcUpdateEmailCount() {
                var count = $('.wvc-email-list-item').length;
                var $count = $('.wvc-email-count');

                if (count > 0) {
                    $count.text(count).show();
                } else {
                    $count.hide();
                }
            }

            // Initialize count on page load
            wvcUpdateEmailCount();

            // Test email functionality
            $('#wvc_test_email_btn').on('click', function(e) {
                e.preventDefault();

                var $btn = $(this);
                var $result = $('#wvc_test_email_result');
                var formId = $('input[name="form_id"]').val();

                // Get all email addresses from the list
                var emails = [];
                $('input[name="email_addresses[]"]').each(function() {
                    emails.push($(this).val());
                });

                if (emails.length === 0) {
                    $result.html('<span style="color: #dc3545;">⚠️ Please add at least one email address first</span>');
                    return;
                }

                // Disable button and show loading
                $btn.prop('disabled', true).text('Sending...');
                $result.html('<span style="color: #666;">📤 Sending test email...</span>');

                // Send AJAX request
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'wvc_send_test_email',
                        nonce: '<?php echo wp_create_nonce('wvc_test_email_nonce'); ?>',
                        form_id: formId,
                        emails: emails
                    },
                    success: function(response) {
                        if (response.success) {
                            var msg = '<span style="color: #28a745;">✅ ' + response.data.message + '</span>';
                            if (response.data.note) {
                                msg += '<br><small style="color: #666;">' + response.data.note + '</small>';
                            }
                            $result.html(msg);

                            // Also log to console for debugging
                            console.log('WVC Test Email Response:', response.data);
                            if (response.data.logs_url) {
                                console.log('View logs at:', response.data.logs_url);
                            } else if (response.data.log_path) {
                                console.log('Check debug log at:', response.data.log_path);
                            }
                        } else {
                            $result.html('<span style="color: #dc3545;">❌ ' + response.data.message + '</span>');
                            console.error('WVC Test Email Error:', response.data);
                        }
                    },
                    error: function() {
                        $result.html('<span style="color: #dc3545;">❌ Failed to send test email</span>');
                    },
                    complete: function() {
                        $btn.prop('disabled', false).text('Send Test Email');
                        setTimeout(function() {
                            $result.fadeOut(300, function() {
                                $(this).html('').show();
                            });
                        }, 5000);
                    }
                });
            });

            // Hooks Panel JavaScript
            var hookCounter = 0;

            // Add new hook
            $('.wvc-add-hook-btn').on('click', function() {
                hookCounter++;
                var hookId = 'hook_' + Date.now() + '_' + hookCounter;

                var hookHtml = `
                    <div class="wvc-hook-item" data-hook-id="${hookId}">
                        <div class="wvc-hook-item-header">
                            <div class="wvc-hook-item-left">
                                <span class="wvc-hook-type-badge">Slack</span>
                                <label style="margin: 0;">
                                    <input type="checkbox" name="hooks[${hookId}][enabled]" value="1" checked>
                                    Enable this hook
                                </label>
                            </div>
                            <div class="wvc-hook-item-right">
                                <button type="button" class="wvc-hook-test-btn" data-hook-id="${hookId}">
                                    Test
                                </button>
                                <button type="button" class="wvc-hook-remove-btn" data-hook-id="${hookId}">
                                    Remove
                                </button>
                            </div>
                        </div>

                        <input type="hidden" name="hooks[${hookId}][id]" value="${hookId}">
                        <input type="hidden" name="hooks[${hookId}][type]" value="slack">

                        <div class="wvc-hook-field">
                            <label>Hook Name</label>
                            <input type="text" name="hooks[${hookId}][name]" placeholder="e.g., Sales Team Slack" required>
                            <small>A friendly name to identify this hook</small>
                        </div>

                        <div class="wvc-hook-field">
                            <label>Webhook URL <span style="color: red;">*</span></label>
                            <input type="url" name="hooks[${hookId}][webhook_url]" placeholder="https://hooks.slack.com/services/..." required>
                            <small>Must be an HTTPS URL. Get this from your Slack workspace settings.</small>
                        </div>

                        <div class="wvc-hook-field">
                            <label>Channel Override (Optional)</label>
                            <input type="text" name="hooks[${hookId}][channel]" placeholder="#sales">
                            <small>Leave empty to use the webhook's default channel. Use # for channels or @ for DMs.</small>
                        </div>

                        <div class="wvc-hook-status-message" style="display:none;"></div>
                    </div>
                `;

                $('#wvc-hooks-container').append(hookHtml);
            });

            // Remove hook
            $(document).on('click', '.wvc-hook-remove-btn', function() {
                if (confirm('Are you sure you want to remove this hook?')) {
                    $(this).closest('.wvc-hook-item').fadeOut(300, function() {
                        $(this).remove();
                    });
                }
            });

            // Test hook
            $(document).on('click', '.wvc-hook-test-btn', function() {
                var $btn = $(this);
                var $hookItem = $btn.closest('.wvc-hook-item');
                var $statusMsg = $hookItem.find('.wvc-hook-status-message');
                var hookId = $btn.data('hook-id');

                // Get hook data
                var hookData = {
                    type: 'slack',
                    name: $hookItem.find('input[name*="[name]"]').val(),
                    webhook_url: $hookItem.find('input[name*="[webhook_url]"]').val(),
                    channel: $hookItem.find('input[name*="[channel]"]').val()
                };

                // Validate
                if (!hookData.name || !hookData.webhook_url) {
                    $statusMsg.removeClass('success').addClass('error')
                        .html('⚠️ Please fill in the hook name and webhook URL first')
                        .fadeIn();
                    setTimeout(function() { $statusMsg.fadeOut(); }, 3000);
                    return;
                }

                if (!hookData.webhook_url.startsWith('https://')) {
                    $statusMsg.removeClass('success').addClass('error')
                        .html('⚠️ Webhook URL must start with https://')
                        .fadeIn();
                    setTimeout(function() { $statusMsg.fadeOut(); }, 3000);
                    return;
                }

                // Get form ID
                var formId = $('input[name="form_id"]').val();

                // Disable button and show loading
                $btn.prop('disabled', true).text('Testing...');
                $statusMsg.removeClass('success error')
                    .html('📤 Sending test message...')
                    .fadeIn();

                // Send AJAX request
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'wvc_test_hook',
                        nonce: '<?php echo wp_create_nonce('wvc_test_hook_nonce'); ?>',
                        form_id: formId,
                        hook: hookData
                    },
                    success: function(response) {
                        if (response.success) {
                            $statusMsg.removeClass('error').addClass('success')
                                .html('✅ ' + response.data.message);
                        } else {
                            $statusMsg.removeClass('success').addClass('error')
                                .html('❌ ' + response.data.message);
                        }
                    },
                    error: function() {
                        $statusMsg.removeClass('success').addClass('error')
                            .html('❌ Failed to send test message');
                    },
                    complete: function() {
                        $btn.prop('disabled', false).text('Test');
                        setTimeout(function() {
                            $statusMsg.fadeOut();
                        }, 5000);
                    }
                });
            });

            // Initialize hook counter from existing hooks
            $('.wvc-hook-item').each(function(index) {
                hookCounter = Math.max(hookCounter, index + 1);
            });
        });
    </script>
    <?php
}

/**
 * Hide "Add New" button with CSS on form submissions page
 */
function wvc_hide_add_new_button_css() {
    global $pagenow, $typenow;

    if ($pagenow === 'edit.php' && $typenow === 'wvc_form_data') {
        echo '<style>
            .page-title-action,
            .add-new-h2,
            .wp-heading-inline + .page-title-action {
                display: none !important;
            }
        </style>';
    }
}
