<?php

namespace WVC\FormSubmissions;

/**
 * Admin Notices - Admin Notice Functions
 *
 * Display admin notices
 *
 * @package    WVC_Theme
 * @subpackage FormSubmissions
 */

// Prevent direct access
if (!defined("ABSPATH")) {
    exit;
}

/**
 * Display export error notices
 */
function wvc_display_export_notices() {
    // Only show on the form submissions page
    if (!isset($_GET['page']) || $_GET['page'] !== 'wvc_form_submissions') {
        return;
    }

    // Check for export error
    if (isset($_GET['export_error'])) {
        $error_type = sanitize_text_field($_GET['export_error']);

        if ($error_type === 'no_submissions') {
            echo '<div class="notice notice-warning is-dismissible">';
            echo '<p><strong>Export Failed:</strong> No submissions found for the selected date range. Please adjust your filters and try again.</p>';
            echo '</div>';
        }
    }

    // Check for hook settings saved
    if (isset($_GET['hook_settings_saved'])) {
        $status = sanitize_text_field($_GET['hook_settings_saved']);

        if ($status === 'success') {
            echo '<div class="notice notice-success is-dismissible">';
            echo '<p><strong>Hook Settings Saved:</strong> Your webhook configurations have been saved successfully.</p>';
            echo '</div>';
        } elseif ($status === 'partial') {
            $invalid = isset($_GET['invalid']) ? sanitize_text_field($_GET['invalid']) : 'Some hooks had errors';
            echo '<div class="notice notice-warning is-dismissible">';
            echo '<p><strong>Hook Settings Partially Saved:</strong> Some hooks were saved, but the following had errors: ' . esc_html($invalid) . '</p>';
            echo '</div>';
        }
    }
}

/**
 * Add admin notice with form submission statistics on form data pages
 */
function wvc_admin_form_stats_notice() {
    $screen = get_current_screen();
    if ($screen->post_type !== 'wvc_form_data') {
        return;
    }

    // Check if we're filtering by form ID
    $current_form_id = isset($_GET['form_id']) ? sanitize_text_field($_GET['form_id']) : '';

    if ($current_form_id) {
        // Show statistics for the selected form
        $form_count = wvc_get_form_submission_count($current_form_id);
        echo '<div class="notice notice-info">';
        echo '<p><strong>Showing submissions for Form ID: ' . esc_html($current_form_id) . '</strong> ';
        echo '(' . $form_count . ' submissions) | ';
        echo '<a href="' . admin_url('edit.php?post_type=wvc_form_data') . '">View All Forms</a> | ';
        echo '<a href="' . admin_url('edit.php?post_type=wvc_form_data&page=wvc_form_overview') . '">Form Overview</a>';
        echo '</p>';
        echo '</div>';
    } else {
        // Get submission statistics
        $total_submissions = wp_count_posts('wvc_form_data')->private;
        $today_submissions = get_posts(array(
            'post_type' => 'wvc_form_data',
            'post_status' => 'private',
            'date_query' => array(
                array(
                    'after' => 'today'
                )
            ),
            'fields' => 'ids',
            'posts_per_page' => -1
        ));
        $today_count = count($today_submissions);

        $this_week_submissions = get_posts(array(
            'post_type' => 'wvc_form_data',
            'post_status' => 'private',
            'date_query' => array(
                array(
                    'after' => '1 week ago'
                )
            ),
            'fields' => 'ids',
            'posts_per_page' => -1
        ));
        $week_count = count($this_week_submissions);

        echo '<div class="notice notice-info">';
        echo '<p><strong>Form Submission Statistics:</strong> ';
        echo 'Total: ' . $total_submissions . ' | ';
        echo 'Today: ' . $today_count . ' | ';
        echo 'This Week: ' . $week_count . ' | ';
        //echo '<a href="' . admin_url('edit.php?post_type=wvc_form_data&page=wvc_form_overview') . '">View Form Overview</a>';
        echo '</p>';
        echo '</div>';
    }
}
