<?php
/**
 * Style Kits Loader
 *
 * This file bootstraps and initializes all Style Kit related functionality.
 * It loads required classes, registers hooks, and sets up the complete
 * Style Kit management system for the WVC theme.
 *
 * @package    WVC_Theme
 * @subpackage Style_Kits
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

if (!defined("ABSPATH")) {
    exit;
}

/**
 * WVC Style Kits Module
 */
class WVC_Style_Kits_Module
{
    
    private static $instance = null;
    
    public static function get_instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct()
    {
        $this->load_dependencies();
        $this->init_components();
    }
    
    /**
     * Load required files
     */
    private function load_dependencies()
    {
        $includes_path = get_template_directory() . "/includes/kits/";
        
        // Load core classes
        include_once $includes_path . "class-style-kit-post-type.php";
        include_once $includes_path . "class-style-kit-rest-api.php";
    }
    
    /**
     * Initialize components
     */
    private function init_components()
    {
        // Initialize post type
        new WVC_Style_Kit_Post_Type();
        
        // Initialize REST API
        new WVC_Style_Kit_REST_API();
    }
}

// Initialize the module
function wvc_init_style_kits_module()
{
    return WVC_Style_Kits_Module::get_instance();
}

// Hook into WordPress initialization
add_action("init", "wvc_init_style_kits_module", 5); 