<?php
/**
 * Template Hierarchy Helper
 *
 * This file contains utility functions and filters for WordPress template
 * hierarchy management. It provides custom template loading logic and
 * template selection functionality for the WVC theme.
 *
 * @package    WVC_Theme
 * @subpackage Includes
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

add_filter('template_include', 'wvc_custom_template_router', 99);


function wvc_custom_template_router($template) {

    return $template;
    # TODO

}


function get_template_hierarchy_for_current_request() {
    global $post;

    // Front Page
    if (is_front_page()) {
        if (is_page()) {
            $slug = $post->post_name;
            $id = $post->ID;
            return [
                get_theme_file_path("front-page.php"),
                get_theme_file_path("page-{$slug}.php"),
                get_theme_file_path("page-{$id}.php"),
                get_theme_file_path("page.php"),
                get_theme_file_path("singular.php"),
                get_theme_file_path("index.php"),
            ];
        } else {
            return [
                get_theme_file_path("front-page.php"),
                get_theme_file_path("home.php"),
                get_theme_file_path("index.php"),
            ];
        }
    }

    // Home Page (blog posts index)
    if (is_home()) {
        return [
            get_theme_file_path("home.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // Page
    if (is_page()) {
        $slug = $post->post_name;
        $id = $post->ID;
        $template = get_page_template_slug($post);
        
        $hierarchy = [];
        
        // Custom page template
        if ($template) {
            $hierarchy[] = get_theme_file_path($template);
        }
        
        $hierarchy = array_merge($hierarchy, [
            get_theme_file_path("page-{$slug}.php"),
            get_theme_file_path("page-{$id}.php"),
            get_theme_file_path("page.php"),
            get_theme_file_path("singular.php"),
            get_theme_file_path("index.php"),
        ]);
        
        return $hierarchy;
    }

    // Single Post
    if (is_single()) {
        $post_type = get_post_type();
        $slug = $post->post_name;
        $id = $post->ID;
        
        if ($post_type === "post") {
            return [
                get_theme_file_path("single-{$slug}.php"),
                get_theme_file_path("single-{$id}.php"),
                get_theme_file_path("single.php"),
                get_theme_file_path("singular.php"),
                get_theme_file_path("index.php"),
            ];
        } else {
            return [
                get_theme_file_path("single-{$post_type}-{$slug}.php"),
                get_theme_file_path("single-{$post_type}.php"),
                get_theme_file_path("single.php"),
                get_theme_file_path("singular.php"),
                get_theme_file_path("index.php"),
            ];
        }
    }

    // Attachment
    if (is_attachment()) {
        $mime_type = get_post_mime_type();
        $subtype = get_post_mime_type();
        if ($mime_type) {
            $mime_parts = explode("/", $mime_type);
            $type = $mime_parts[0];
            $subtype = isset($mime_parts[1]) ? $mime_parts[1] : "";
        }
        
        return [
            get_theme_file_path("attachment-{$subtype}.php"),
            get_theme_file_path("attachment-{$type}.php"),
            get_theme_file_path("attachment.php"),
            get_theme_file_path("single-attachment.php"),
            get_theme_file_path("single.php"),
            get_theme_file_path("singular.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // Category Archive
    if (is_category()) {
        $category = get_queried_object();
        $slug = $category->slug;
        $id = $category->term_id;
        
        return [
            get_theme_file_path("category-{$slug}.php"),
            get_theme_file_path("category-{$id}.php"),
            get_theme_file_path("category.php"),
            get_theme_file_path("archive.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // Tag Archive
    if (is_tag()) {
        $tag = get_queried_object();
        $slug = $tag->slug;
        $id = $tag->term_id;
        
        return [
            get_theme_file_path("tag-{$slug}.php"),
            get_theme_file_path("tag-{$id}.php"),
            get_theme_file_path("tag.php"),
            get_theme_file_path("archive.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // Custom Taxonomy Archive
    if (is_tax()) {
        $term = get_queried_object();
        $taxonomy = $term->taxonomy;
        $slug = $term->slug;
        
        return [
            get_theme_file_path("taxonomy-{$taxonomy}-{$slug}.php"),
            get_theme_file_path("taxonomy-{$taxonomy}.php"),
            get_theme_file_path("taxonomy.php"),
            get_theme_file_path("archive.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // Author Archive
    if (is_author()) {
        $author = get_queried_object();
        $nicename = $author->user_nicename;
        $id = $author->ID;
        
        return [
            get_theme_file_path("author-{$nicename}.php"),
            get_theme_file_path("author-{$id}.php"),
            get_theme_file_path("author.php"),
            get_theme_file_path("archive.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // Date Archive
    if (is_date()) {
        if (is_year()) {
            return [
                get_theme_file_path("date.php"),
                get_theme_file_path("archive.php"),
                get_theme_file_path("index.php"),
            ];
        } elseif (is_month()) {
            return [
                get_theme_file_path("date.php"),
                get_theme_file_path("archive.php"),
                get_theme_file_path("index.php"),
            ];
        } elseif (is_day()) {
            return [
                get_theme_file_path("date.php"),
                get_theme_file_path("archive.php"),
                get_theme_file_path("index.php"),
            ];
        }
    }

    // Custom Post Type Archive
    if (is_post_type_archive()) {
        $post_type = get_query_var("post_type");
        if (is_array($post_type)) {
            $post_type = reset($post_type);
        }
        
        return [
            get_theme_file_path("archive-{$post_type}.php"),
            get_theme_file_path("archive.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // Generic Archive
    if (is_archive()) {
        return [
            get_theme_file_path("archive.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // Search Results
    if (is_search()) {
        return [
            get_theme_file_path("search.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // 404 Page
    if (is_404()) {
        return [
            get_theme_file_path("404.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // Privacy Policy Page
    if (is_privacy_policy()) {
        return [
            get_theme_file_path("privacy-policy.php"),
            get_theme_file_path("page.php"),
            get_theme_file_path("singular.php"),
            get_theme_file_path("index.php"),
        ];
    }

    // Fallback
    return [get_theme_file_path("index.php")];
}