<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



class WVC_TenWeb_Api
{

    protected static $instance = null;

    private $re_api_url;
    private $access_token;
    private $domain_id;
    private $workspace_id;

    public function __construct()
    {
        $this->setVariables();
    }


    public static function get_instance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    private function get_headers()
    {
        if( defined('TWBB_RESELLER_MODE') && TWBB_RESELLER_MODE ) {
            return [
                'x-api-key' => defined('AI_BUILDER_KIT_API_KEY') ? AI_BUILDER_KIT_API_KEY : '',
            ];
        } else {
            return [
                'Authorization' => 'Bearer ' . $this->access_token,
                'Accept' => 'application/x.10webaiassistantapi.v1+json'
            ];
        }
    }

    private function setVariables() {
        $this->access_token = get_site_option(TENWEB_PREFIX . '_access_token');
        $this->domain_id = get_option('tenweb_domain_id');
        $this->workspace_id = get_site_option('tenweb_workspace_id', '');
        $this->re_api_url = defined('TENWEB_BUILDER_API') ? TENWEB_BUILDER_API : '';
    }


    public function getPluginUpdateData($slug = 'wvc-theme') {
        if( defined('TWBB_RESELLER_MODE') && TWBB_RESELLER_MODE ) {
            $url = $this->re_api_url . 'product-info';
            $header = $this->get_headers();
        } else {
            if (defined('TENWEB_DASHBOARD') && strpos(TENWEB_DASHBOARD, 'test') !== false) {
                $url = 'https://testcore.10web.io/';
            } else {
                $url = 'https://core.10web.io/';
            }
            $url = $url . 'api/workspaces/' . $this->workspace_id . '/products/product-info';
            $header = [
                'Authorization' => 'Bearer ' . $this->access_token . '.gTcjslfqqBFFwJKBnFgQYhkQEJpplLaDKfj',
                'Accept' => 'application/x.10webcore.v1+json'
            ];
        }
        $res = wp_safe_remote_post($url, [
            'headers' => $header,
            'body'    => ['slug' => $slug ],
            'timeout' => 50000,//phpcs:ignore WordPressVIPMinimum.Performance.RemoteRequestTimeout.timeout_timeout
        ]);
        $data = json_decode(wp_remote_retrieve_body($res), true);

        $data['data']['url'] = "https://10web.io/";
        $data['data']['package'] = $data['data']["plugin_url"];
        $data['data']['new_version'] = $data['data']["version"];
        return $data['data'] ?? [];
    }

}
