<?php
/**
 * Visual Composer Content Handler
 *
 * This file contains functions and filters for handling Visual Composer
 * content-managers integration. It manages VC shortcodes, content-managers processing,
 * and theme compatibility with Visual Composer plugin.
 *
 * @package    WVC_Theme
 * @subpackage Includes
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

class WVCContentManager {
    
    private static $instance = null;
    
    private function __construct() {
        // Private constructor to prevent direct instantiation
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    // Prevent cloning
    private function __clone() {}
    
    // Prevent unserialization
    public function __wakeup() {
        throw new Exception("Cannot unserialize a singleton.");
    }
    
    public function vc_override() {     
        // Add your custom condition logic here

        # this method should return the class name to add to body class
        # possible values are:
        # - wvc-page  - when we have a page built with WVC, we replace the default page tempalte with the page content-managers
            # this corresponds to virtual page-about.php template logic
        # - wvc-template - when we have a template built with WVC, we replace the current tempalte with the WVC content-managers
            # this corresponds to category.php replacement logic
        # empty string means no override

        return "wvc-page"; // placeholder condition

        
    }

    public function get_available_pages() {
        return array("about");
    }

    public function get_available_templates() {
        return array("category");
    }
    
    public function get_content_template($type, $slug) {
        return "Hello World";
    }
    
}

function wvc_custom_add_body_class($classes) {
    $vc_content = WVCContentManager::getInstance();
    if (is_search() && $vc_content->vc_override()) {
        $classes[] = $vc_content->vc_override(); // your custom class
    }
    // Check if woocommerce class exists and add wvc-woocommerce
    $woocommerce_key = array_search("woocommerce", $classes);
    if ($woocommerce_key !== false) {
        $classes[] = "wvc-woocommerce";
        unset($classes[$woocommerce_key]);
    }
    // Check if woocommerce-page class exists and add wvc-woocommerce
    $woocommerce_page_key = array_search("woocommerce-page", $classes);
    if ($woocommerce_page_key !== false) {
        $classes[] = "wvc-woocommerce";
        unset($classes[$woocommerce_page_key]);
    }
    return $classes;
}
add_filter("body_class", "wvc_custom_add_body_class", 11);
