<?php
/**
 * Search Form Template
 *
 * This template provides a custom search form layout. It's used by
 * get_search_form() function throughout the theme and includes
 * accessibility features and proper form structure.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */

/**
 * Template for displaying search forms
 */
?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url(home_url("/")); ?>">
    <label>
        <span class="screen-reader-text"><?php echo _x("Search for:", "label", "wvc-theme"); ?></span>
        <input type="search" class="search-field" placeholder="<?php echo esc_attr_x("Search...", "placeholder", "wvc-theme"); ?>" value="<?php echo get_search_query(); ?>" name="s" />
    </label>
    <input type="submit" class="search-submit btn" value="<?php echo esc_attr_x("Search", "submit button", "wvc-theme"); ?>" />
</form> 