<?php

/**
 * Page Template
 *
 * This template displays pages created using vibecode editor pages.
 *
 * @package    WVC_Theme
 * @subpackage Templates
 * @author     10Web
 * @since      1.0.0
 * @version    1.0.0
 * @link       https://github.com/your-repo/wvc-theme
 */



get_header();

remove_filter( 'the_content', 'wpautop' );



while (have_posts()) : the_post(); 
    $content = get_the_content();
    if (empty(trim($content))) {
        // Include empty page template if no content
        include get_template_directory() . '/wvc-empty-page.php';
        return;
    }
?>
    <article id="post-<?php the_ID(); ?>" <?php post_class("page"); ?>>
        <?php
        // Get the content
        $content = get_the_content();
        $post_id = get_the_ID();
        $js  = get_post_meta($post_id, "_wvc_page_js", true);
        $shortcodes = [];

        $js_pattern = '/\[([a-zA-Z][a-zA-Z0-9_\-]*)(?:\s+[a-zA-Z0-9_\-="\s]+)?\]/';
      
        if ( !empty($js) && preg_match_all( $js_pattern, $js, $js_matches ) && ! empty( $js_matches[0] ) ) {
            foreach ( $js_matches[0] as $index => $shortcode ) {
                // Additional validation: check if it looks like a real shortcode
                $shortcode_name = $js_matches[1][$index];

                $shortcode_exists = shortcode_exists($shortcode_name);
                if(!$shortcode_exists) {
                    continue; // Skip if shortcode is not registered
                }
                
                if (strlen($shortcode_name) > 2 || strpos($shortcode_name, '_') !== false || strpos($shortcode_name, '-') !== false) {
                    $decoded_shortcode = html_entity_decode( $shortcode );
                    $shortcodes[] = $decoded_shortcode;
                } 
            }
        } 

        // Find shortcodes in content
        $pattern = get_shortcode_regex();
        if ( preg_match_all( '/' . $pattern . '/s', $content, $matches ) && ! empty( $matches[2] ) ) {
           $shortcodes_found = $matches[0];
            // $log_entry = "Shortcodes found on page (ID: " . get_the_ID() . "):\n";
            
            $decoded_shortcodes = [];
            foreach ( $shortcodes_found as $shortcode ) {
                $decoded_shortcode = html_entity_decode( $shortcode );
                $decoded_shortcodes[] = $decoded_shortcode;
                // $shortcodes[] = $decoded_shortcode; // Add to main shortcodes array
                // $log_entry .= "- " . $decoded_shortcode . "\n";
            }
            error_log( $log_entry );

            // Replace encoded shortcodes with decoded ones in the content
            $content = str_replace($shortcodes_found, $decoded_shortcodes, $content);
        }

        // Make shortcodes array distinct
        // $shortcodes = array_unique($shortcodes);

        // Create wrappers for each shortcode and echo them (hidden)
      
        $content = apply_filters('the_content', $content);
    
        
        echo $content;


        // error_log("Shortcodes to process: " . print_r($shortcodes, true));

        foreach ($shortcodes as $shortcode) {  
            // Compile the shortcode
            $compiled_shortcode = do_shortcode($shortcode);

            if($compiled_shortcode === false) {
                continue; // Skip to the next shortcode
            }

            if($compiled_shortcode === $shortcode) {
               continue; // Skip if shortcode did not compile
            }

            // Use the full shortcode as ID, changing double quotes to single quotes
            $wrapper_id = str_replace('"', "'", $shortcode);
          
            
            // Echo the wrapper with the compiled shortcode (hidden with CSS)
            echo '<wrapper id="' . esc_attr($wrapper_id) . '" style="display: none;">';
            echo $compiled_shortcode;
            echo '</wrapper>';

        }


        
        
        
        ?>
    </article>
<?php endwhile;

get_footer();
?>